<?php
/**
 * Base Controller Class
 * All controllers extend this class
 */
class Controller {
    protected function view($view, $data = []) {
        extract($data);
        require_once __DIR__ . '/../app/views/' . $view . '.php';
    }

    protected function model($model) {
        require_once __DIR__ . '/../app/models/' . $model . '.php';
        return new $model();
    }

    protected function redirect($url) {
        header("Location: " . $url);
        exit;
    }

    protected function json($data) {
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }

    protected function validate($data, $rules) {
        $errors = [];
        foreach ($rules as $field => $rule) {
            $ruleParts = explode('|', $rule);
            foreach ($ruleParts as $r) {
                if ($r === 'required' && empty($data[$field])) {
                    $errors[$field] = "$field is required";
                }
                if (strpos($r, 'min:') === 0) {
                    $min = substr($r, 4);
                    if (strlen($data[$field]) < $min) {
                        $errors[$field] = "$field must be at least $min characters";
                    }
                }
                if (strpos($r, 'max:') === 0) {
                    $max = substr($r, 4);
                    if (strlen($data[$field]) > $max) {
                        $errors[$field] = "$field must not exceed $max characters";
                    }
                }
                if ($r === 'email' && !filter_var($data[$field], FILTER_VALIDATE_EMAIL)) {
                    $errors[$field] = "$field must be a valid email";
                }
                if ($r === 'numeric' && !is_numeric($data[$field])) {
                    $errors[$field] = "$field must be numeric";
                }
            }
        }
        return $errors;
    }
}