<?php 
$page_title = "Edit User";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Edit User</h2>
<form method="POST" action="/sms/public/user/update/<?= $user['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Username</label>
            <input type="text" name="username" value="<?= htmlspecialchars($user['username']) ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Full Name</label>
            <input type="text" name="full_name" value="<?= htmlspecialchars($user['full_name']) ?>" class="form-control" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Email</label>
        <input type="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" class="form-control" required>
    </div>
    
    <div class="mb-3">
        <label>Role</label>
        <select name="role_id" class="form-select" required>
            <?php foreach ($roles as $role): ?>
                <option value="<?= $role['id'] ?>" <?= $role['id'] == $user['role_id'] ? 'selected' : '' ?>>
                    <?= $role['name'] ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <button type="submit" class="btn btn-warning">Update User</button>
    <a href="/sms/public/user/index" class="btn btn-secondary">Cancel</a>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>