<?php 
$page_title = "Create User";
require_once __DIR__ . '/../includes/header.php'; 
$errors = SessionHelper::getFlash('user_errors');
?>
<h2>Create New User</h2>

<?php if ($errors): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php foreach ($errors as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<form method="POST" action="/sms/public/user/store" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Username</label>
            <input type="text" name="username" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Full Name</label>
            <input type="text" name="full_name" class="form-control" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Role</label>
        <select name="role_id" class="form-select" required>
            <?php foreach ($roles as $role): ?>
                <option value="<?= $role['id'] ?>"><?= $role['name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Create User</button>
    <a href="/sms/public/user/index" class="btn btn-secondary">Cancel</a>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>