<?php 
$page_title = "Edit Vehicle";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Vehicle</h2>
<form method="POST" action="/sms/public/transport/updateVehicle/<?= $vehicle['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Vehicle Number</label>
            <input type="text" name="vehicle_no" value="<?= htmlspecialchars($vehicle['vehicle_no']) ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Vehicle Type</label>
            <select name="vehicle_type" class="form-select" required>
                <option value="Bus" <?= $vehicle['vehicle_type'] == 'Bus' ? 'selected' : '' ?>>Bus</option>
                <option value="Van" <?= $vehicle['vehicle_type'] == 'Van' ? 'selected' : '' ?>>Van</option>
                <option value="Mini Bus" <?= $vehicle['vehicle_type'] == 'Mini Bus' ? 'selected' : '' ?>>Mini Bus</option>
                <option value="Car" <?= $vehicle['vehicle_type'] == 'Car' ? 'selected' : '' ?>>Car</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Capacity</label>
            <input type="number" name="capacity" value="<?= $vehicle['capacity'] ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Route Name</label>
            <input type="text" name="route_name" value="<?= htmlspecialchars($vehicle['route_name']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Driver Name</label>
            <input type="text" name="driver_name" value="<?= htmlspecialchars($vehicle['driver_name']) ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Driver Phone</label>
            <input type="text" name="driver_phone" value="<?= htmlspecialchars($vehicle['driver_phone']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1" <?= $vehicle['status'] == 1 ? 'selected' : '' ?>>Active</option>
            <option value="0" <?= $vehicle['status'] == 0 ? 'selected' : '' ?>>Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Vehicle</button>
    <a href="/sms/public/transport/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>