<?php 
$page_title = "Add Vehicle";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> Add New Vehicle</h2>
<form method="POST" action="/sms/public/transport/storeVehicle" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Vehicle Number <span class="text-danger">*</span></label>
            <input type="text" name="vehicle_no" class="form-control" placeholder="e.g., KCA 123A" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Vehicle Type <span class="text-danger">*</span></label>
            <select name="vehicle_type" class="form-select" required>
                <option value="Bus">Bus</option>
                <option value="Van">Van</option>
                <option value="Mini Bus">Mini Bus</option>
                <option value="Car">Car</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Capacity (Students) <span class="text-danger">*</span></label>
            <input type="number" name="capacity" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Route Name</label>
            <input type="text" name="route_name" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Driver Name</label>
            <input type="text" name="driver_name" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Driver Phone</label>
            <input type="text" name="driver_phone" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Save Vehicle</button>
    <a href="/sms/public/transport/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>