<?php 
$page_title = "Transport Routes";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('transport_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-map"></i> Transport Routes</h2>
    <a href="/sms/public/transport/createRoute" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add Route
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Route Name</th>
                    <th>Start Point</th>
                    <th>End Point</th>
                    <th>Distance</th>
                    <th>Time</th>
                    <th>Fare</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($routes as $route): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($route['route_name']) ?></strong></td>
                    <td><?= htmlspecialchars($route['start_point']) ?></td>
                    <td><?= htmlspecialchars($route['end_point']) ?></td>
                    <td><?= $route['distance_km'] ?> km</td>
                    <td><?= htmlspecialchars($route['estimated_time']) ?></td>
                    <td>$<?= number_format($route['fare_amount'], 2) ?></td>
                    <td>
                        <span class="badge bg-<?= $route['status'] ? 'success' : 'danger' ?>">
                            <?= $route['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/transport/editRoute/<?= $route['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/transport/deleteRoute/<?= $route['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>