<?php 
$page_title = "Edit Route";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Route</h2>
<form method="POST" action="/sms/public/transport/updateRoute/<?= $route['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Route Name</label>
        <input type="text" name="route_name" value="<?= htmlspecialchars($route['route_name']) ?>" class="form-control" required>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Start Point</label>
            <input type="text" name="start_point" value="<?= htmlspecialchars($route['start_point']) ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>End Point</label>
            <input type="text" name="end_point" value="<?= htmlspecialchars($route['end_point']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Distance (km)</label>
            <input type="number" step="0.1" name="distance_km" value="<?= $route['distance_km'] ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Estimated Time</label>
            <input type="text" name="estimated_time" value="<?= htmlspecialchars($route['estimated_time']) ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Fare Amount</label>
            <input type="number" step="0.01" name="fare_amount" value="<?= $route['fare_amount'] ?>" class="form-control" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1" <?= $route['status'] == 1 ? 'selected' : '' ?>>Active</option>
            <option value="0" <?= $route['status'] == 0 ? 'selected' : '' ?>>Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Route</button>
    <a href="/sms/public/transport/routes" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>