<?php 
/**
 * Subjects List View
 */
$page_title = "Subjects";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('subject_msg');
$errors = SessionHelper::getFlash('subject_errors');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-book"></i> Subjects</h2>
    <a href="/sms/public/subject/create" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add Subject
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
        <?= $flash['message'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($errors): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach ($errors as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Subject Name</th>
                        <th>Code</th>
                        <th>Classes</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($subjects)): ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted py-4">No subjects found. Create your first subject!</td>
                    </tr>
                    <?php else: ?>
                        <?php foreach ($subjects as $subject): 
                            $subjectModel = new SubjectModel();
                            $count = $subjectModel->getClassCount($subject['id']);
                        ?>
                        <tr>
                            <td><?= $subject['id'] ?></td>
                            <td><strong><?= htmlspecialchars($subject['name']) ?></strong></td>
                            <td><span class="badge bg-secondary"><?= htmlspecialchars($subject['code']) ?></span></td>
                            <td><span class="badge bg-success"><?= $count ?> Classes</span></td>
                            <td><?= date('M d, Y', strtotime($subject['created_at'])) ?></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="/sms/public/subject/edit/<?= $subject['id'] ?>" class="btn btn-warning" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="/sms/public/subject/delete/<?= $subject['id'] ?>" class="btn btn-danger" 
                                       onclick="return confirm('Are you sure?')" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>