<?php 
/**
 * Edit Subject View
 */
$page_title = "Edit Subject";
require_once __DIR__ . '/../includes/header.php'; 
$errors = SessionHelper::getFlash('subject_errors');
?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h4 class="mb-0"><i class="bi bi-pencil"></i> Edit Subject</h4>
            </div>
            <div class="card-body p-4">
                <?php if ($errors): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?= $error ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="/sms/public/subject/update/<?= $subject['id'] ?>">
                    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Subject Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="<?= htmlspecialchars($subject['name']) ?>" required maxlength="100">
                    </div>
                    
                    <div class="mb-3">
                        <label for="code" class="form-label">Subject Code <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="code" name="code" 
                               value="<?= htmlspecialchars($subject['code']) ?>" required maxlength="20">
                    </div>
                    
                    <div class="alert alert-info">
                        <small><i class="bi bi-info-circle"></i> 
                        Subject ID: <?= $subject['id'] ?> | Created: <?= date('M d, Y', strtotime($subject['created_at'])) ?></small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-check-circle"></i> Update Subject
                        </button>
                        <a href="/sms/public/subject/index" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>