<?php 
$page_title = "Edit Student";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2>Edit Student</h2>
<form method="POST" action="/sms/public/student/update/<?= $student['id'] ?>" class="card p-4 shadow">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <input type="hidden" name="parent_id" value="<?= $student['parent_id'] ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Admission No</label>
            <input type="text" value="<?= htmlspecialchars($student['admission_no']) ?>" class="form-control" disabled>
        </div>
        <div class="col-md-6 mb-3">
            <label>Class</label>
            <select name="class_id" class="form-select" required>
                <?php foreach ($classes as $class): ?>
                    <option value="<?= $class['id'] ?>" <?= $class['id'] == $student['class_id'] ? 'selected' : '' ?>>
                        <?= $class['name'] ?> - <?= $class['section'] ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>First Name</label>
            <input type="text" name="first_name" value="<?= htmlspecialchars($student['first_name']) ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Last Name</label>
            <input type="text" name="last_name" value="<?= htmlspecialchars($student['last_name']) ?>" class="form-control" required>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Gender</label>
            <select name="gender" class="form-select" required>
                <option value="Male" <?= $student['gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
                <option value="Female" <?= $student['gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
            </select>
        </div>
        <div class="col-md-6 mb-3">
            <label>Date of Birth</label>
            <input type="date" name="dob" value="<?= $student['dob'] ?>" class="form-control" required>
        </div>
    </div>

    <button type="submit" class="btn btn-warning">Update Student</button>
    <a href="/sms/public/student/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>