<?php 
$page_title = "Add Student";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2>Add New Student</h2>
<form method="POST" action="/sms/public/student/store" class="card p-4 shadow">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Admission No</label>
            <input type="text" name="admission_no" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Class</label>
            <select name="class_id" class="form-select" required>
                <?php foreach ($classes as $class): ?>
                    <option value="<?= $class['id'] ?>"><?= $class['name'] ?> - <?= $class['section'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>First Name</label>
            <input type="text" name="first_name" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Last Name</label>
            <input type="text" name="last_name" class="form-control" required>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Gender</label>
            <select name="gender" class="form-select" required>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
            </select>
        </div>
        <div class="col-md-6 mb-3">
            <label>Date of Birth</label>
            <input type="date" name="dob" class="form-control" required>
        </div>
    </div>

    <hr>
    <h4>Parent Details</h4>
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Father's Name</label>
            <input type="text" name="father_name" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Mother's Name</label>
            <input type="text" name="mother_name" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Phone</label>
            <input type="text" name="phone" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control">
        </div>
        <div class="col-md-12 mb-3">
            <label>Address</label>
            <textarea name="address" class="form-control"></textarea>
        </div>
    </div>

    <button type="submit" class="btn btn-success">Save Student</button>
    <a href="/sms/public/student/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>