<?php 
$page_title = "Parent Details";
require_once __DIR__ . '/../includes/header.php'; 
?>

<div class="row">
    <div class="col-md-8">
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-person"></i> Parent/Guardian Information</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Name:</strong><br>
                        <?= htmlspecialchars($parent['first_name'] . ' ' . $parent['last_name']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Type:</strong><br>
                        <span class="badge bg-info"><?= $parent['guardian_type'] ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>ID Number:</strong><br>
                        <?= htmlspecialchars($parent['id_number'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Phone:</strong><br>
                        <?= htmlspecialchars($parent['phone_primary']) ?>
                        <?php if ($parent['phone_secondary']): ?>
                            <br><small class="text-muted"><?= htmlspecialchars($parent['phone_secondary']) ?></small>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Email:</strong><br>
                        <?= htmlspecialchars($parent['email'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Occupation:</strong><br>
                        <?= htmlspecialchars($parent['occupation'] ?? '-') ?>
                        <?php if ($parent['employer']): ?>
                            <br><small class="text-muted"><?= htmlspecialchars($parent['employer']) ?></small>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-12 mb-3">
                        <strong>Address:</strong><br>
                        <?= nl2br(htmlspecialchars($parent['address'] ?? 'N/A')) ?>
                        <br><?= htmlspecialchars($parent['city'] ?? '') ?>, <?= htmlspecialchars($parent['country'] ?? '') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Emergency Contact:</strong><br>
                        <?= htmlspecialchars($parent['emergency_contact_name'] ?? '-') ?>
                        <br><?= htmlspecialchars($parent['emergency_contact_phone'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <span class="badge bg-<?= $parent['status'] ? 'success' : 'danger' ?>">
                            <?= $parent['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="/sms/public/parent/edit/<?= $parent['id'] ?>" class="btn btn-warning">Edit</a>
                <a href="/sms/public/parent/index" class="btn btn-secondary">Back</a>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow mb-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-people"></i> Children (<?= count($students) ?>)</h5>
            </div>
            <div class="card-body">
                <?php if (empty($students)): ?>
                    <p class="text-muted">No children assigned</p>
                    <a href="/sms/public/parent/assign" class="btn btn-sm btn-primary">Assign Student</a>
                <?php else: ?>
                    <ul class="list-group">
                        <?php foreach ($students as $student): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong><?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></strong>
                                <br><small><?= htmlspecialchars($student['admission_no']) ?></small>
                            </div>
                            <?php if ($student['is_primary']): ?>
                                <span class="badge bg-primary">Primary</span>
                            <?php endif; ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card shadow">
            <div class="card-body">
                <a href="/sms/public/parent/createAccount" class="btn btn-outline-primary w-100 mb-2">
                    <i class="bi bi-person-plus"></i> Create Portal Account
                </a>
                <a href="/sms/public/parent/assign" class="btn btn-outline-success w-100">
                    <i class="bi bi-person-plus"></i> Assign Student
                </a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>