<?php 
$page_title = "Parent-Student Assignments";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('parent_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-people"></i> Parent-Student Assignments</h2>
    <a href="/sms/public/parent/assign" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> New Assignment
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Parent/Guardian</th>
                    <th>Phone</th>
                    <th>Student</th>
                    <th>Admission No</th>
                    <th>Relationship</th>
                    <th>Assigned Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($assignments as $assign): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($assign['first_name'] . ' ' . $assign['last_name']) ?></strong></td>
                    <td><?= htmlspecialchars($assign['phone_primary']) ?></td>
                    <td><?= htmlspecialchars($assign['student_first'] . ' ' . $assign['student_last']) ?></td>
                    <td><?= htmlspecialchars($assign['admission_no']) ?></td>
                    <td>
                        <?php if ($assign['is_primary']): ?>
                            <span class="badge bg-primary">Primary</span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Secondary</span>
                        <?php endif; ?>
                    </td>
                    <td><?= date('M d, Y', strtotime($assign['created_at'])) ?></td>
                    <td>
                        <a href="/sms/public/parent/removeAssignment/<?= $assign['student_id'] ?>/<?= $assign['parent_id'] ?>" 
                           class="btn btn-sm btn-danger" onclick="return confirm('Remove this assignment?')">Remove</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>