<?php 
$page_title = "Notifications";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Notifications</h2>
<div class="list-group">
    <?php foreach ($notifications as $notif): ?>
    <div class="list-group-item list-group-item-action <?= $notif['is_read'] ? '' : 'fw-bold' ?>">
        <div class="d-flex w-100 justify-content-between">
            <h5 class="mb-1"><?= htmlspecialchars($notif['title']) ?></h5>
            <small><?= $notif['created_at'] ?></small>
        </div>
        <p class="mb-1"><?= htmlspecialchars($notif['message']) ?></p>
        <span class="badge bg-<?= $notif['type'] ?>"><?= $notif['type'] ?></span>
        <?php if (!$notif['is_read']): ?>
            <a href="/sms/public/notification/markRead/<?= $notif['id'] ?>" class="btn btn-sm btn-link">Mark as Read</a>
        <?php endif; ?>
    </div>
    <?php endforeach; ?>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>