<?php 
/**
 * Notifications List
 */
$page_title = "Notifications";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-bell"></i> Notifications</h2>

<div class="list-group">
    <?php if (empty($notifications)): ?>
    <div class="list-group-item text-center text-muted py-5">
        <i class="bi bi-bell-slash display-4"></i>
        <p class="mb-0">No notifications</p>
    </div>
    <?php else: ?>
        <?php foreach ($notifications as $notif): ?>
        <div class="list-group-item list-group-item-action <?= $notif['is_read'] ? '' : 'fw-bold bg-light' ?>">
            <div class="d-flex w-100 justify-content-between">
                <h5 class="mb-1"><?= htmlspecialchars($notif['title']) ?></h5>
                <small><?= date('M d, Y h:i A', strtotime($notif['created_at'])) ?></small>
            </div>
            <p class="mb-1"><?= htmlspecialchars($notif['message']) ?></p>
            <span class="badge bg-<?= $notif['type'] ?>"><?= $notif['type'] ?></span>
            <?php if (!$notif['is_read']): ?>
                <a href="/sms/public/notification/markRead/<?= $notif['id'] ?>" class="btn btn-sm btn-link">Mark as Read</a>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>