<?php 
/**
 * View Single Message
 */
$page_title = "View Message";
require_once __DIR__ . '/../includes/header.php'; 
?>

<div class="card shadow">
    <div class="card-header bg-primary text-white">
        <h4 class="mb-0"><i class="bi bi-envelope-open"></i> Message Details</h4>
    </div>
    <div class="card-body">
        <div class="mb-3">
            <strong>From:</strong> <?= htmlspecialchars($message['sender_name']) ?>
        </div>
        <div class="mb-3">
            <strong>Subject:</strong> <?= htmlspecialchars($message['subject']) ?>
        </div>
        <div class="mb-3">
            <strong>Date:</strong> <?= date('M d, Y h:i A', strtotime($message['created_at'])) ?>
        </div>
        <hr>
        <div class="mb-3">
            <strong>Message:</strong>
            <div class="p-3 bg-light rounded mt-2">
                <?= nl2br(htmlspecialchars($message['message'])) ?>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <a href="/sms/public/message/compose?to=<?= $message['sender_id'] ?>" class="btn btn-primary">Reply</a>
        <a href="/sms/public/message/inbox" class="btn btn-secondary">Back to Inbox</a>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>