<?php 
$page_title = "Sent Messages";
require_once __DIR__ . '/../includes/header.php'; 
?>
<div class="d-flex justify-content-between mb-4">
    <h2>Sent Messages</h2>
    <a href="/sms/public/message/compose" class="btn btn-primary">Compose</a>
</div>

<table class="table table-hover">
    <thead><tr><th>To</th><th>Subject</th><th>Date</th><th>Status</th></tr></thead>
    <tbody>
        <?php foreach ($messages as $msg): ?>
        <tr>
            <td><?= htmlspecialchars($msg['receiver_name']) ?></td>
            <td><?= htmlspecialchars($msg['subject']) ?></td>
            <td><?= $msg['created_at'] ?></td>
            <td><?= $msg['is_read'] ? '<span class="badge bg-success">Read</span>' : '<span class="badge bg-warning">Pending</span>' ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>