<?php 
$page_title = "Medical Visits";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('medical_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-clipboard-data"></i> Medical Visits</h2>
    <div>
        <select class="form-select d-inline-block w-auto" onchange="window.location.href='/sms/public/medical/visits?status='+this.value">
            <option value="">All Status</option>
            <option value="Open" <?= ($status ?? '') == 'Open' ? 'selected' : '' ?>>Open</option>
            <option value="In Treatment" <?= ($status ?? '') == 'In Treatment' ? 'selected' : '' ?>>In Treatment</option>
            <option value="Closed" <?= ($status ?? '') == 'Closed' ? 'selected' : '' ?>>Closed</option>
        </select>
        <a href="/sms/public/medical/createVisit" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Visit
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Date/Time</th>
                    <th>Student</th>
                    <th>Admission</th>
                    <th>Complaint</th>
                    <th>Diagnosis</th>
                    <th>Attended By</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($visits as $visit): ?>
                <tr>
                    <td><?= $visit['visit_date'] ?> <small><?= $visit['visit_time'] ?></small></td>
                    <td><?= htmlspecialchars($visit['first_name'] . ' ' . $visit['last_name']) ?></td>
                    <td><?= htmlspecialchars($visit['admission_no']) ?></td>
                    <td><?= htmlspecialchars(substr($visit['complaint'], 0, 40)) ?>...</td>
                    <td><?= htmlspecialchars($visit['diagnosis'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($visit['staff_name'] ?? '-') ?></td>
                    <td>
                        <span class="badge bg-<?= $visit['status'] == 'Closed' ? 'success' : ($visit['status'] == 'Open' ? 'warning' : 'info') ?>">
                            <?= $visit['status'] ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/medical/editVisit/<?= $visit['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <?php if ($visit['status'] != 'Closed'): ?>
                            <a href="/sms/public/medical/dispense/<?= $visit['id'] ?>" class="btn btn-sm btn-info text-white">Dispense</a>
                            <a href="/sms/public/medical/closeVisit/<?= $visit['id'] ?>" class="btn btn-sm btn-success">Close</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>