<?php 
$page_title = "New Medical Visit";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> New Medical Visit</h2>
<form method="POST" action="/sms/public/medical/storeVisit" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Select Student <span class="text-danger">*</span></label>
            <select name="student_id" class="form-select" required>
                <option value="">-- Select Student --</option>
                <?php foreach ($students as $student): ?>
                    <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3 mb-3">
            <label>Visit Date <span class="text-danger">*</span></label>
            <input type="date" name="visit_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        <div class="col-md-3 mb-3">
            <label>Visit Time <span class="text-danger">*</span></label>
            <input type="time" name="visit_time" class="form-control" value="<?= date('H:i') ?>" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Complaint/Reason for Visit <span class="text-danger">*</span></label>
        <textarea name="complaint" class="form-control" rows="3" required placeholder="Describe the student's complaint or reason for visit"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Diagnosis</label>
        <textarea name="diagnosis" class="form-control" rows="2" placeholder="Medical diagnosis (if known)"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Treatment Given</label>
        <textarea name="treatment" class="form-control" rows="2" placeholder="Treatment provided"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Medications Prescribed</label>
        <textarea name="medications_prescribed" class="form-control" rows="2" placeholder="List of medications prescribed"></textarea>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Referred To</label>
            <input type="text" name="referred_to" class="form-control" placeholder="Hospital/Specialist name">
        </div>
        <div class="col-md-6 mb-3">
            <label>Follow-up Date</label>
            <input type="date" name="follow_up_date" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="Open">Open</option>
            <option value="In Treatment">In Treatment</option>
            <option value="Referred">Referred</option>
            <option value="Closed">Closed</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Additional Notes</label>
        <textarea name="notes" class="form-control" rows="2"></textarea>
    </div>
    
    <button type="submit" class="btn btn-success">Record Visit</button>
    <a href="/sms/public/medical/visits" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>