<?php 
$page_title = "Adjust Stock";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-arrow-left-right"></i> Adjust Stock</h2>
<div class="card p-4">
    <div class="alert alert-info">
        <strong>Medication:</strong> <?= htmlspecialchars($medication['medication_name']) ?><br>
        <strong>Current Stock:</strong> <?= $medication['stock_quantity'] ?><br>
        <strong>Reorder Level:</strong> <?= $medication['reorder_level'] ?>
    </div>
    
    <form method="POST" action="/sms/public/medical/storeStockAdjustment/<?= $medication['id'] ?>">
        <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
        
        <div class="mb-3">
            <label>Quantity Change <span class="text-danger">*</span></label>
            <input type="number" name="quantity_change" class="form-control" required>
            <small class="text-muted">Use positive numbers to add stock, negative to remove</small>
        </div>
        
        <div class="mb-3">
            <label>Reason/Notes <span class="text-danger">*</span></label>
            <textarea name="notes" class="form-control" rows="3" required></textarea>
        </div>
        
        <button type="submit" class="btn btn-success">Adjust Stock</button>
        <a href="/sms/public/medical/medications" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>