<?php 
$page_title = "Edit Medical Staff";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Medical Staff</h2>
<form method="POST" action="/sms/public/medical/updateStaff/<?= $staff['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Name</label>
            <input type="text" name="name" value="<?= htmlspecialchars($staff['name']) ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Qualification</label>
            <input type="text" name="qualification" value="<?= htmlspecialchars($staff['qualification']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>License Number</label>
            <input type="text" name="license_number" value="<?= htmlspecialchars($staff['license_number']) ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Specialization</label>
            <input type="text" name="specialization" value="<?= htmlspecialchars($staff['specialization']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Phone</label>
            <input type="text" name="phone" value="<?= htmlspecialchars($staff['phone']) ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" value="<?= htmlspecialchars($staff['email']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1" <?= $staff['status'] == 1 ? 'selected' : '' ?>>Active</option>
            <option value="0" <?= $staff['status'] == 0 ? 'selected' : '' ?>>Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Staff</button>
    <a href="/sms/public/medical/staff" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>