<?php 
$page_title = "Medical Record";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-file-earmark-medical"></i> Medical Record</h2>

<div class="card shadow mb-4">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">Student: <?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></h5>
    </div>
    <div class="card-body">
        <?php if ($record): ?>
        <div class="row">
            <div class="col-md-4 mb-3">
                <strong>Blood Group:</strong><br>
                <?= htmlspecialchars($record['blood_group'] ?? 'Unknown') ?>
            </div>
            <div class="col-md-4 mb-3">
                <strong>Height:</strong><br>
                <?= $record['height_cm'] ?? '-' ?> cm
            </div>
            <div class="col-md-4 mb-3">
                <strong>Weight:</strong><br>
                <?= $record['weight_kg'] ?? '-' ?> kg
            </div>
            <div class="col-md-12 mb-3">
                <strong>Allergies:</strong><br>
                <?= nl2br(htmlspecialchars($record['allergies'] ?? 'None')) ?>
            </div>
            <div class="col-md-12 mb-3">
                <strong>Chronic Conditions:</strong><br>
                <?= nl2br(htmlspecialchars($record['chronic_conditions'] ?? 'None')) ?>
            </div>
            <div class="col-md-12 mb-3">
                <strong>Emergency Contact:</strong><br>
                <?= htmlspecialchars($record['emergency_contact_name'] ?? '-') ?> 
                (<?= htmlspecialchars($record['emergency_contact_phone'] ?? '-') ?>)
            </div>
        </div>
        <?php else: ?>
        <p class="text-muted">No medical record found for this student.</p>
        <a href="/sms/public/medical/createRecord" class="btn btn-primary">Create Record</a>
        <?php endif; ?>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>