<?php 
$page_title = "Pharmacy/Medications";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('medical_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-capsule"></i> Pharmacy & Medications</h2>
    <div>
        <a href="/sms/public/medical/inventory" class="btn btn-info text-white">
            <i class="bi bi-box-seam"></i> Inventory Log
        </a>
        <a href="/sms/public/medical/createMedication" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Medication
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<?php if (!empty($low_stock)): ?>
<div class="alert alert-warning">
    <strong><i class="bi bi-exclamation-triangle"></i> Low Stock Alert:</strong> <?= count($low_stock) ?> medications are below reorder level!
</div>
<?php endif; ?>

<?php if (!empty($expired)): ?>
<div class="alert alert-danger">
    <strong><i class="bi bi-exclamation-triangle"></i> Expired Medications:</strong> <?= count($expired) ?> medications have expired!
</div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Medication</th>
                    <th>Generic Name</th>
                    <th>Category</th>
                    <th>Form</th>
                    <th>Strength</th>
                    <th>Stock</th>
                    <th>Reorder</th>
                    <th>Price</th>
                    <th>Expiry</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($medications as $med): ?>
                <tr class="<?= $med['stock_quantity'] <= $med['reorder_level'] ? 'table-warning' : '' ?>">
                    <td><strong><?= htmlspecialchars($med['medication_name']) ?></strong></td>
                    <td><?= htmlspecialchars($med['generic_name'] ?? '-') ?></td>
                    <td><span class="badge bg-info"><?= htmlspecialchars($med['category']) ?></span></td>
                    <td><?= $med['dosage_form'] ?></td>
                    <td><?= htmlspecialchars($med['strength']) ?></td>
                    <td>
                        <span class="badge bg-<?= $med['stock_quantity'] <= $med['reorder_level'] ? 'danger' : 'success' ?>">
                            <?= $med['stock_quantity'] ?>
                        </span>
                    </td>
                    <td><?= $med['reorder_level'] ?></td>
                    <td>$<?= number_format($med['unit_price'], 2) ?></td>
                    <td>
                        <?= $med['expiry_date'] ?>
                        <?php if ($med['expiry_date'] < date('Y-m-d')): ?>
                            <span class="badge bg-danger">Expired</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="/sms/public/medical/editMedication/<?= $med['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/medical/stockAdjustment/<?= $med['id'] ?>" class="btn btn-sm btn-info text-white">Adjust</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>