<?php 
$page_title = "Add Medication";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-capsule"></i> Add Medication</h2>
<form method="POST" action="/sms/public/medical/storeMedication" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Medication Name <span class="text-danger">*</span></label>
            <input type="text" name="medication_name" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Generic Name</label>
            <input type="text" name="generic_name" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Category</label>
            <input type="text" name="category" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Dosage Form</label>
            <select name="dosage_form" class="form-select">
                <option value="Tablet">Tablet</option>
                <option value="Capsule">Capsule</option>
                <option value="Syrup">Syrup</option>
                <option value="Injection">Injection</option>
                <option value="Cream">Cream</option>
                <option value="Inhaler">Inhaler</option>
                <option value="Other">Other</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Strength</label>
            <input type="text" name="strength" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Stock Quantity <span class="text-danger">*</span></label>
            <input type="number" name="stock_quantity" class="form-control" value="0" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Reorder Level</label>
            <input type="number" name="reorder_level" class="form-control" value="10">
        </div>
        <div class="col-md-4 mb-3">
            <label>Unit Price</label>
            <input type="number" step="0.01" name="unit_price" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Expiry Date</label>
            <input type="date" name="expiry_date" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Batch Number</label>
            <input type="text" name="batch_number" class="form-control">
        </div>
    </div>
    
    <button type="submit" class="btn btn-success">Add Medication</button>
    <a href="/sms/public/medical/medications" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>