<?php 
$page_title = "Medical Incidents";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('medical_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-exclamation-triangle"></i> Medical Incidents</h2>
    <a href="/sms/public/medical/createIncident" class="btn btn-danger">
        <i class="bi bi-plus-circle"></i> Report Incident
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Date/Time</th>
                    <th>Student</th>
                    <th>Type</th>
                    <th>Location</th>
                    <th>Reported By</th>
                    <th>Parent Notified</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($incidents as $incident): ?>
                <tr>
                    <td><?= $incident['incident_date'] ?> <small><?= $incident['incident_time'] ?></small></td>
                    <td><?= htmlspecialchars($incident['first_name'] . ' ' . $incident['last_name']) ?></td>
                    <td><span class="badge bg-<?= $incident['incident_type'] == 'Emergency' ? 'danger' : 'warning' ?>"><?= $incident['incident_type'] ?></span></td>
                    <td><?= htmlspecialchars($incident['location']) ?></td>
                    <td><?= htmlspecialchars($incident['reported_by_name']) ?></td>
                    <td>
                        <?php if ($incident['parent_notified']): ?>
                            <span class="badge bg-success">Yes</span>
                        <?php else: ?>
                            <span class="badge bg-danger">No</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge bg-<?= $incident['status'] == 'Closed' ? 'success' : 'warning' ?>">
                            <?= $incident['status'] ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/medical/viewIncident/<?= $incident['id'] ?>" class="btn btn-sm btn-info text-white">View</a>
                        <?php if ($incident['status'] != 'Closed'): ?>
                            <a href="/sms/public/medical/updateIncident/<?= $incident['id'] ?>" class="btn btn-sm btn-warning">Update</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>