<?php 
$page_title = "Incident Details";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-exclamation-triangle"></i> Incident Details</h2>

<div class="card shadow mb-4">
    <div class="card-header bg-danger text-white">
        <h5 class="mb-0">Incident #<?= $incident['id'] ?></h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-3">
                <strong>Student:</strong><br>
                <?= htmlspecialchars($incident['first_name'] . ' ' . $incident['last_name']) ?> 
                (<?= htmlspecialchars($incident['admission_no']) ?>)
            </div>
            <div class="col-md-6 mb-3">
                <strong>Date/Time:</strong><br>
                <?= $incident['incident_date'] ?> <?= $incident['incident_time'] ?>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Type:</strong><br>
                <span class="badge bg-danger"><?= $incident['incident_type'] ?></span>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Location:</strong><br>
                <?= htmlspecialchars($incident['location']) ?>
            </div>
            <div class="col-md-12 mb-3">
                <strong>Description:</strong><br>
                <?= nl2br(htmlspecialchars($incident['description'])) ?>
            </div>
            <div class="col-md-12 mb-3">
                <strong>Witnesses:</strong><br>
                <?= nl2br(htmlspecialchars($incident['witnesses'] ?? 'None')) ?>
            </div>
            <div class="col-md-12 mb-3">
                <strong>Action Taken:</strong><br>
                <?= nl2br(htmlspecialchars($incident['action_taken'] ?? 'None')) ?>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Parent Notified:</strong><br>
                <span class="badge bg-<?= $incident['parent_notified'] ? 'success' : 'danger' ?>">
                    <?= $incident['parent_notified'] ? 'Yes' : 'No' ?>
                </span>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Status:</strong><br>
                <span class="badge bg-<?= $incident['status'] == 'Closed' ? 'success' : 'warning' ?>"><?= $incident['status'] ?></span>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <a href="/sms/public/medical/updateIncident/<?= $incident['id'] ?>" class="btn btn-warning">Update</a>
        <a href="/sms/public/medical/incidents" class="btn btn-secondary">Back</a>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>