<?php 
$page_title = "Report Incident";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-exclamation-triangle"></i> Report Medical Incident</h2>
<form method="POST" action="/sms/public/medical/storeIncident" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Incident Date <span class="text-danger">*</span></label>
            <input type="date" name="incident_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Incident Time <span class="text-danger">*</span></label>
            <input type="time" name="incident_time" class="form-control" value="<?= date('H:i') ?>" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Incident Type <span class="text-danger">*</span></label>
        <select name="incident_type" class="form-select" required>
            <option value="Injury">Injury</option>
            <option value="Illness">Illness</option>
            <option value="Accident">Accident</option>
            <option value="Emergency">Emergency</option>
            <option value="Other">Other</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Description <span class="text-danger">*</span></label>
        <textarea name="description" class="form-control" rows="4" required></textarea>
    </div>
    
    <div class="mb-3">
        <label>Location</label>
        <input type="text" name="location" class="form-control" placeholder="Where did the incident occur?">
    </div>
    
    <div class="mb-3">
        <label>Witnesses</label>
        <textarea name="witnesses" class="form-control" rows="2"></textarea>
    </div>
    
    <button type="submit" class="btn btn-danger">Report Incident</button>
    <a href="/sms/public/medical/incidents" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>