<?php 
$page_title = "Immunizations";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-shield-check"></i> Immunization Records</h2>

<?php if (!empty($due)): ?>
<div class="alert alert-warning">
    <strong><i class="bi bi-exclamation-triangle"></i> Due Immunizations:</strong> <?= count($due) ?> students have overdue immunizations
</div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h3>Due Immunizations</h3>
    <a href="/sms/public/medical/createImmunization" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Record Immunization
    </a>
</div>

<div class="card shadow mb-4">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Student</th>
                    <th>Vaccine</th>
                    <th>Dose</th>
                    <th>Due Date</th>
                    <th>Days Overdue</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($due as $d): ?>
                <tr class="table-warning">
                    <td><?= htmlspecialchars($d['first_name'] . ' ' . $d['last_name']) ?></td>
                    <td><?= htmlspecialchars($d['vaccine_name']) ?></td>
                    <td><?= htmlspecialchars($d['dose_number']) ?></td>
                    <td><?= $d['next_due_date'] ?></td>
                    <td><?= floor((time() - strtotime($d['next_due_date'])) / 86400) ?> days</td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>