<?php 
$page_title = "Add Medical Condition";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> Add Medical Condition</h2>
<form method="POST" action="/sms/public/medical/storeCondition" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Condition Name <span class="text-danger">*</span></label>
        <input type="text" name="condition_name" class="form-control" required>
    </div>
    
    <div class="mb-3">
        <label>Type <span class="text-danger">*</span></label>
        <select name="condition_type" class="form-select" required>
            <option value="Allergy">Allergy</option>
            <option value="Chronic">Chronic</option>
            <option value="Disability">Disability</option>
            <option value="Other">Other</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Description</label>
        <textarea name="description" class="form-control" rows="3"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Add Condition</button>
    <a href="/sms/public/medical/conditions" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>