<?php 
$page_title = "Return Book";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-arrow-return-left"></i> Return Book</h2>
<div class="card p-4">
    <div class="alert alert-info">
        <strong>Book:</strong> <?= htmlspecialchars($issue['book_title']) ?><br>
        <strong>Student:</strong> <?= htmlspecialchars($issue['first_name'] . ' ' . $issue['last_name']) ?> (<?= htmlspecialchars($issue['admission_no']) ?>)<br>
        <strong>Issue Date:</strong> <?= $issue['issue_date'] ?><br>
        <strong>Due Date:</strong> <?= $issue['due_date'] ?>
    </div>
    
    <form method="POST" action="/sms/public/library/processReturn/<?= $issue['id'] ?>">
        <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
        
        <div class="mb-3">
            <label>Return Date <span class="text-danger">*</span></label>
            <input type="date" name="return_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        
        <div class="alert alert-warning">
            <i class="bi bi-exclamation-triangle"></i> 
            Fine will be calculated automatically if the book is returned after the due date.
            Fine rate: $10 per day.
        </div>
        
        <button type="submit" class="btn btn-success">Process Return</button>
        <a href="/sms/public/library/issues" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>