<?php 
/**
 * Library Dashboard
 */
$page_title = "Library";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-book"></i> Library Management</h2>
<p class="text-muted mb-4">Manage books, issues, and returns</p>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-book"></i> Books</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Browse and manage library books</p>
                <a href="/sms/public/library/index" class="btn btn-primary">View Books</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-journal-check"></i> Issues</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Manage book issues and returns</p>
                <a href="/sms/public/library/issues" class="btn btn-success">View Issues</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Overdue</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">View overdue books</p>
                <a href="/sms/public/library/overdue" class="btn btn-danger">View Overdue</a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>