<?php
/**
 * Header Include File
 * Common header for all pages
 */
if (!isset($page_title)) {
    $page_title = 'School Management System';
}

// Get notification count for badge
$unreadNotifCount = 0;
if (Auth::isLoggedIn()) {
    $notifModel = new NotificationModel();
    $unreadNotifCount = $notifModel->getUnreadCount(Auth::user()['id']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= htmlspecialchars($page_title) ?> - School Management System</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/sms/public/assets/css/style.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" href="/sms/public/assets/images/favicon.ico" type="image/x-icon">
    
    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar-brand {
            font-weight: 700;
        }
        .notification-badge {
            position: absolute;
            top: 5px;
            right: 5px;
            font-size: 0.6rem;
        }
    </style>
</head>
<body>
    <!-- Top Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="/sms/public/dashboard">
                <i class="bi bi-mortarboard-fill"></i> School SMS
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/sms/public/dashboard">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                    </li>
                    
                    <?php if (Auth::isLoggedIn() && in_array(Auth::user()['role_name'], ['Super Admin', 'Admin', 'Teacher'])): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-book"></i> Academic
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sms/public/student/index"><i class="bi bi-people"></i> Students</a></li>
                            <li><a class="dropdown-item" href="/sms/public/class/index"><i class="bi bi-building"></i> Classes</a></li>
                            <li><a class="dropdown-item" href="/sms/public/subject/index"><i class="bi bi-journal"></i> Subjects</a></li>
                            <li><a class="dropdown-item" href="/sms/public/attendance/index"><i class="bi bi-calendar-check"></i> Attendance</a></li>
                            <li><a class="dropdown-item" href="/sms/public/exam/index"><i class="bi bi-journal-check"></i> Exams</a></li>
                            <li><a class="dropdown-item" href="/sms/public/result/index"><i class="bi bi-file-earmark-bar-graph"></i> Results</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-currency-dollar"></i> Finance
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sms/public/finance/index"><i class="bi bi-receipt"></i> Dashboard</a></li>
                            <li><a class="dropdown-item" href="/sms/public/finance/invoices"><i class="bi bi-file-earmark-text"></i> Invoices</a></li>
                            <li><a class="dropdown-item" href="/sms/public/finance/structure"><i class="bi bi-gear"></i> Fee Structure</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-building"></i> Resources
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sms/public/library/index"><i class="bi bi-book"></i> Library</a></li>
                            <li><a class="dropdown-item" href="/sms/public/transport/index"><i class="bi bi-bus-front"></i> Transport</a></li>
                            <li><a class="dropdown-item" href="/sms/public/boarding/index"><i class="bi bi-door-open"></i> Boarding</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-heart-pulse"></i> Welfare
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sms/public/parent/index"><i class="bi bi-people"></i> Parents</a></li>
                            <li><a class="dropdown-item" href="/sms/public/medical/index"><i class="bi bi-hospital"></i> Medical</a></li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (Auth::isLoggedIn() && in_array(Auth::user()['role_name'], ['Super Admin', 'Admin'])): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="/sms/public/user/index">
                            <i class="bi bi-person-gear"></i> Users
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <!-- Right Side Navigation -->
                <ul class="navbar-nav">
                    <!-- Notifications -->
                    <li class="nav-item dropdown">
                        <a class="nav-link position-relative" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-bell"></i>
                            <?php if ($unreadNotifCount > 0): ?>
                                <span class="badge bg-danger rounded-pill notification-badge"><?= $unreadNotifCount ?></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" style="width: 300px; max-height: 400px; overflow-y: auto;">
                            <li><h6 class="dropdown-header">Notifications</h6></li>
                            <?php if ($unreadNotifCount > 0): ?>
                                <?php foreach ($unreadNotifCount as $notif): ?>
                                <li>
                                    <a class="dropdown-item" href="/sms/public/notification/markRead/<?= $notif['id'] ?>">
                                        <small class="fw-bold"><?= htmlspecialchars($notif['title']) ?></small>
                                        <br><small class="text-muted"><?= htmlspecialchars(substr($notif['message'], 0, 50)) ?>...</small>
                                    </a>
                                </li>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <li><a class="dropdown-item text-center text-muted" href="#">No new notifications</a></li>
                            <?php endif; ?>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-center" href="/sms/public/notification/list">View All</a></li>
                        </ul>
                    </li>
                    
                    <!-- Messages -->
                    <li class="nav-item">
                        <a class="nav-link" href="/sms/public/message/inbox">
                            <i class="bi bi-envelope"></i>
                        </a>
                    </li>
                    
                    <!-- User Menu -->
                    <?php if (Auth::isLoggedIn()): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-person-circle"></i>
                            <?= htmlspecialchars(Auth::user()['full_name']) ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><h6 class="dropdown-header"><?= htmlspecialchars(Auth::user()['role_name']) ?></h6></li>
                            <li><a class="dropdown-item" href="/sms/public/dashboard"><i class="bi bi-speedometer2"></i> Dashboard</a></li>
                            <li><a class="dropdown-item" href="/sms/public/user/view/<?= Auth::user()['id'] ?>"><i class="bi bi-person"></i> Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="/sms/public/auth/logout"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
                        </ul>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="/sms/public/">
                            <i class="bi bi-box-arrow-in-right"></i> Login
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Main Content Container -->
    <div class="container-fluid mt-4">