<?php 
$page_title = "Receipt";
require_once __DIR__ . '/../includes/header.php'; 
?>
<div class="card p-4" id="receiptArea">
    <div class="text-center border-bottom pb-3 mb-3">
        <h2>Payment Receipt</h2>
        <p>School Management System</p>
    </div>
    <div class="row mb-3">
        <div class="col-6"><strong>Invoice No:</strong> <?= htmlspecialchars($invoice['invoice_no']) ?></div>
        <div class="col-6 text-end"><strong>Date:</strong> <?= date('Y-m-d') ?></div>
    </div>
    <div class="row mb-3">
        <div class="col-6"><strong>Student:</strong> <?= htmlspecialchars($invoice['first_name'] . ' ' . $invoice['last_name']) ?></div>
        <div class="col-6 text-end"><strong>Admission:</strong> <?= htmlspecialchars($invoice['admission_no']) ?></div>
    </div>
    
    <table class="table table-bordered mt-3">
        <thead><tr><th>Description</th><th class="text-end">Amount</th></tr></thead>
        <tbody>
            <?php foreach ($payments as $pay): ?>
            <tr>
                <td>Payment via <?= $pay['payment_method'] ?> (<?= $pay['payment_date'] ?>)</td>
                <td class="text-end"><?= $pay['amount'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Total Paid</th>
                <th class="text-end"><?= $invoice['paid_amount'] ?></th>
            </tr>
            <tr>
                <th>Balance Due</th>
                <th class="text-end"><?= $invoice['balance_amount'] ?></th>
            </tr>
        </tfoot>
    </table>
    <div class="text-center mt-4">
        <p>Thank you for your payment.</p>
        <button onclick="window.print()" class="btn btn-secondary">Print Receipt</button>
        <a href="/sms/public/finance/invoices" class="btn btn-primary">Back</a>
    </div>
</div>
<style>
@media print {
    .navbar, .btn { display: none !important; }
    #receiptArea { border: none !important; shadow: none !important; }
}
</style>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>