<?php 
$page_title = "Invoices";
require_once __DIR__ . '/../includes/header.php'; 
?>
<div class="d-flex justify-content-between">
    <h2>Invoices</h2>
    <a href="/sms/public/finance/invoice" class="btn btn-primary">Create Invoice</a>
</div>
<table class="table table-striped mt-3">
    <thead><tr><th>Invoice</th><th>Student</th><th>Total</th><th>Paid</th><th>Balance</th><th>Status</th><th>Action</th></tr></thead>
    <tbody>
        <?php foreach ($invoices as $inv): ?>
        <tr>
            <td><?= htmlspecialchars($inv['invoice_no']) ?></td>
            <td><?= htmlspecialchars($inv['first_name'] . ' ' . $inv['last_name']) ?></td>
            <td><?= $inv['total_amount'] ?></td>
            <td><?= $inv['paid_amount'] ?></td>
            <td><?= $inv['balance_amount'] ?></td>
            <td><span class="badge bg-<?= $inv['status'] == 'Paid' ? 'success' : 'warning' ?>"><?= $inv['status'] ?></span></td>
            <td>
                <?php if($inv['balance_amount'] > 0): ?>
                    <a href="/sms/public/finance/pay/<?= $inv['id'] ?>" class="btn btn-sm btn-success">Pay</a>
                <?php endif; ?>
                <a href="/sms/public/finance/receipt/<?= $inv['id'] ?>" class="btn btn-sm btn-info">Receipt</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>