<?php 
/**
 * Finance Dashboard
 */
$page_title = "Finance";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-currency-dollar"></i> Finance Management</h2>
<p class="text-muted mb-4">Manage school fees, invoices, and payments</p>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-receipt"></i> Invoices</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">View and manage student invoices</p>
                <a href="/sms/public/finance/invoices" class="btn btn-primary">View Invoices</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Create Invoice</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Generate new fee invoices</p>
                <a href="/sms/public/finance/invoice" class="btn btn-success">Create Invoice</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-gear"></i> Fee Structure</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Configure fee structures</p>
                <a href="/sms/public/finance/structure" class="btn btn-info text-white">Manage Structure</a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>