<?php 
/**
 * Edit Exam
 */
$page_title = "Edit Exam";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Exam</h2>
<form method="POST" action="/sms/public/exam/update/<?= $exam['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Exam Name <span class="text-danger">*</span></label>
        <input type="text" name="name" value="<?= htmlspecialchars($exam['name']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Year <span class="text-danger">*</span></label>
        <input type="text" name="year" value="<?= htmlspecialchars($exam['year']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Term <span class="text-danger">*</span></label>
        <select name="term" class="form-select" required>
            <option value="First" <?= $exam['term'] == 'First' ? 'selected' : '' ?>>First Term</option>
            <option value="Second" <?= $exam['term'] == 'Second' ? 'selected' : '' ?>>Second Term</option>
            <option value="Third" <?= $exam['term'] == 'Third' ? 'selected' : '' ?>>Third Term</option>
        </select>
    </div>
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1" <?= $exam['status'] == 1 ? 'selected' : '' ?>>Active</option>
            <option value="0" <?= $exam['status'] == 0 ? 'selected' : '' ?>>Closed</option>
        </select>
    </div>
    
    <div class="d-flex gap-2">
        <button type="submit" class="btn btn-warning">
            <i class="bi bi-check-circle"></i> Update Exam
        </button>
        <a href="/sms/public/exam/index" class="btn btn-secondary">
            <i class="bi bi-x-circle"></i> Cancel
        </a>
    </div>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>