<?php 
$page_title = "Dashboard";
require_once __DIR__ . '/../includes/header.php'; 
$user = Auth::user();

// Get notification count
$notifModel = new NotificationModel();
$unreadCount = $notifModel->getUnreadCount($user['id']);
?>

<div class="row mb-4">
    <div class="col-12">
        <h2>Welcome, <?= htmlspecialchars($user['full_name']) ?></h2>
        <p class="text-muted">Role: <?= htmlspecialchars($user['role_name']) ?></p>
    </div>
</div>

<?php if (in_array($user['role_name'], ['Super Admin', 'Admin'])): ?>
<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h5>Total Students</h5>
                <h2><?= $stats['total_students'] ?? 0 ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h5>Total Revenue</h5>
                <h2>$<?= number_format($stats['total_revenue'] ?? 0, 2) ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <h5>Pending Fees</h5>
                <h2>$<?= number_format($stats['pending_fees'] ?? 0, 2) ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h5>Unread Notifications</h5>
                <h2><?= $unreadCount ?></h2>
            </div>
        </div>
    </div>
</div>

<!-- Charts -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Student Enrollment</div>
            <div class="card-body">
                <canvas id="studentChart"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Revenue Overview</div>
            <div class="card-body">
                <canvas id="revenueChart"></canvas>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Quick Actions -->
<div class="card">
    <div class="card-header">Quick Actions</div>
    <div class="card-body">
        <a href="/sms/public/student/index" class="btn btn-outline-primary">Manage Students</a>
        <a href="/sms/public/exam/index" class="btn btn-outline-success">Manage Exams</a>
        <a href="/sms/public/finance/invoices" class="btn btn-outline-warning">View Invoices</a>
        <a href="/sms/public/message/compose" class="btn btn-outline-info">Send Message</a>
        <a href="/sms/public/user/index" class="btn btn-outline-dark">Manage Users</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
<?php if (in_array($user['role_name'], ['Super Admin', 'Admin'])): ?>
// Student Chart
const studentCtx = document.getElementById('studentChart').getContext('2d');
new Chart(studentCtx, {
    type: 'bar',
    data: {
        labels: ['Grade 1', 'Grade 2', 'Grade 3', 'Grade 4', 'Grade 5'],
        datasets: [{
            label: 'Students',
            data: [25, 30, 28, 35, 32],
            backgroundColor: 'rgba(54, 162, 235, 0.5)'
        }]
    }
});

// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
new Chart(revenueCtx, {
    type: 'line',
     {
        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
        datasets: [{
            label: 'Revenue',
             [5000, 7000, 6000, 8000, 7500, 9000],
            borderColor: 'rgba(75, 192, 192, 1)',
            tension: 0.1
        }]
    }
});
<?php endif; ?>
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>