<?php 
/**
 * Edit Class View
 */
$page_title = "Edit Class";
require_once __DIR__ . '/../includes/header.php'; 
$errors = SessionHelper::getFlash('class_errors');
?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h4 class="mb-0"><i class="bi bi-pencil"></i> Edit Class</h4>
            </div>
            <div class="card-body p-4">
                <?php if ($errors): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?= $error ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="/sms/public/class/update/<?= $class['id'] ?>">
                    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Class Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="<?= htmlspecialchars($class['name']) ?>" required maxlength="50">
                    </div>
                    
                    <div class="mb-3">
                        <label for="section" class="form-label">Section <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="section" name="section" 
                               value="<?= htmlspecialchars($class['section']) ?>" required maxlength="10">
                    </div>
                    
                    <div class="alert alert-info">
                        <small><i class="bi bi-info-circle"></i> 
                        Class ID: <?= $class['id'] ?> | Created: <?= date('M d, Y', strtotime($class['created_at'])) ?></small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-check-circle"></i> Update Class
                        </button>
                        <a href="/sms/public/class/index" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>