<?php 
$page_title = "Boarding Students";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('boarding_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-people"></i> Boarding Students</h2>
    <a href="/sms/public/boarding/assign" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Assign Student
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Admission No</th>
                    <th>Student Name</th>
                    <th>Hostel</th>
                    <th>Room</th>
                    <th>Boarding Type</th>
                    <th>Monthly Fee</th>
                    <th>Admission Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $student): ?>
                <tr>
                    <td><?= htmlspecialchars($student['admission_no']) ?></td>
                    <td><?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></td>
                    <td><?= htmlspecialchars($student['hostel_name']) ?></td>
                    <td><?= htmlspecialchars($student['room_number']) ?></td>
                    <td><span class="badge bg-info"><?= htmlspecialchars($student['boarding_type']) ?></span></td>
                    <td>$<?= number_format($student['monthly_fee'], 2) ?></td>
                    <td><?= $student['admission_date'] ?></td>
                    <td>
                        <a href="/sms/public/boarding/checkout/<?= $student['id'] ?>" class="btn btn-sm btn-danger">Checkout</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>