<?php 
$page_title = "Rooms";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('boarding_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-door-open"></i> Room Management</h2>
    <div>
        <select class="form-select d-inline-block w-auto" onchange="window.location.href='/sms/public/boarding/rooms?hostel='+this.value">
            <option value="">All Hostels</option>
            <?php foreach ($hostels as $hostel): ?>
                <option value="<?= $hostel['id'] ?>" <?= ($hostel_id ?? '') == $hostel['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($hostel['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <a href="/sms/public/boarding/createRoom" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Room
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Hostel</th>
                    <th>Room Number</th>
                    <th>Floor</th>
                    <th>Type</th>
                    <th>Capacity</th>
                    <th>Occupied</th>
                    <th>Available</th>
                    <th>Facilities</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rooms as $room): 
                    $available = $room['capacity'] - $room['current_occupancy'];
                ?>
                <tr>
                    <td><?= htmlspecialchars($room['hostel_name']) ?></td>
                    <td><strong><?= htmlspecialchars($room['room_number']) ?></strong></td>
                    <td><?= htmlspecialchars($room['floor']) ?></td>
                    <td><span class="badge bg-info"><?= $room['room_type'] ?></span></td>
                    <td><?= $room['capacity'] ?></td>
                    <td><span class="badge bg-warning"><?= $room['current_occupancy'] ?></span></td>
                    <td><span class="badge bg-<?= $available > 0 ? 'success' : 'danger' ?>"><?= $available ?></span></td>
                    <td><?= htmlspecialchars($room['facilities'] ?? '-') ?></td>
                    <td>
                        <span class="badge bg-<?= $room['status'] ? 'success' : 'danger' ?>">
                            <?= $room['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/boarding/editRoom/<?= $room['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/boarding/deleteRoom/<?= $room['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>