<?php 
$page_title = "Room Inspection";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-clipboard-check"></i> Room Inspection</h2>
<form method="POST" action="/sms/public/boarding/storeInspection" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Room <span class="text-danger">*</span></label>
        <select name="room_id" class="form-select" required>
            <option value="">-- Select Room --</option>
            <?php foreach ($rooms as $room): ?>
                <option value="<?= $room['id'] ?>">
                    <?= htmlspecialchars($room['hostel_name']) ?> - Room <?= htmlspecialchars($room['room_number']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Inspection Date <span class="text-danger">*</span></label>
        <input type="date" name="inspection_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
    </div>
    
    <div class="mb-3">
        <label>Cleanliness Rating <span class="text-danger">*</span></label>
        <select name="cleanliness" class="form-select" required>
            <option value="Excellent">Excellent</option>
            <option value="Good">Good</option>
            <option value="Fair">Fair</option>
            <option value="Poor">Poor</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Maintenance Issues</label>
        <textarea name="maintenance_issues" class="form-control" rows="3" placeholder="Describe any maintenance issues found"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Action Taken</label>
        <textarea name="action_taken" class="form-control" rows="2" placeholder="What action was taken or needs to be taken"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="Pending">Pending</option>
            <option value="In Progress">In Progress</option>
            <option value="Resolved">Resolved</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Record Inspection</button>
    <a href="/sms/public/boarding/inspections" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>