<?php 
$page_title = "Checkout Student";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-box-arrow-right"></i> Checkout Student from Boarding</h2>
<div class="card p-4">
    <div class="alert alert-info">
        <strong>Student:</strong> <?= htmlspecialchars($boarding['first_name'] . ' ' . $boarding['last_name']) ?> 
        (<?= htmlspecialchars($boarding['admission_no']) ?>)<br>
        <strong>Hostel:</strong> <?= htmlspecialchars($boarding['hostel_name']) ?><br>
        <strong>Room:</strong> <?= htmlspecialchars($boarding['room_number']) ?><br>
        <strong>Admission Date:</strong> <?= $boarding['admission_date'] ?>
    </div>
    
    <form method="POST" action="/sms/public/boarding/processCheckout/<?= $boarding['id'] ?>">
        <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
        
        <div class="mb-3">
            <label>Checkout Date <span class="text-danger">*</span></label>
            <input type="date" name="checkout_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        
        <div class="alert alert-warning">
            <i class="bi bi-exclamation-triangle"></i> 
            This will free up the room bed and mark the student as checked out.
        </div>
        
        <button type="submit" class="btn btn-danger">Process Checkout</button>
        <a href="/sms/public/boarding/students" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>