<?php 
/**
 * Forgot Password Page
 */
$page_title = "Forgot Password";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('auth_msg');
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <i class="bi bi-key display-4 text-primary"></i>
                        <h3 class="mt-3">Forgot Password</h3>
                        <p class="text-muted">Enter your email to receive password reset instructions</p>
                    </div>
                    
                    <?php if ($flash): ?>
                        <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
                    <?php endif; ?>
                    
                    <form method="POST" action="/sms/public/auth/resetRequest">
                        <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="email" name="email" required autofocus>
                            <div class="form-text">We'll send a reset link to this email</div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary w-100 mb-3">
                            <i class="bi bi-send"></i> Send Reset Link
                        </button>
                    </form>
                    
                    <div class="text-center">
                        <a href="/sms/public/" class="text-decoration-none">
                            <i class="bi bi-arrow-left"></i> Back to Login
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="text-center mt-4 text-white">
                <small>&copy; <?= date('Y') ?> School Management System. All rights reserved.</small>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>