<?php
require_once __DIR__ . '/../../core/Database.php';

class UserModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->prepare("SELECT u.*, r.name as role_name 
                                    FROM users u 
                                    JOIN roles r ON u.role_id = r.id 
                                    ORDER BY u.created_at DESC");
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT u.*, r.name as role_name 
                                    FROM users u 
                                    JOIN roles r ON u.role_id = r.id 
                                    WHERE u.id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function getByUsername($username) {
        $stmt = $this->db->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare("INSERT INTO users (role_id, username, email, password, full_name) VALUES (?, ?, ?, ?, ?)");
        return $stmt->execute([
            $data['role_id'],
            $data['username'],
            $data['email'],
            password_hash($data['password'], PASSWORD_BCRYPT),
            $data['full_name']
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare("UPDATE users SET username=?, email=?, full_name=? WHERE id=?");
        return $stmt->execute([$data['username'], $data['email'], $data['full_name'], $id]);
    }

    public function updatePassword($id, $password) {
        $stmt = $this->db->prepare("UPDATE users SET password=? WHERE id=?");
        return $stmt->execute([password_hash($password, PASSWORD_BCRYPT), $id]);
    }

    public function activate($id) {
        $stmt = $this->db->prepare("UPDATE users SET is_active=1 WHERE id=?");
        return $stmt->execute([$id]);
    }

    public function deactivate($id) {
        $stmt = $this->db->prepare("UPDATE users SET is_active=0 WHERE id=?");
        return $stmt->execute([$id]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM users WHERE id=?");
        return $stmt->execute([$id]);
    }

    public function getRoles() {
        $stmt = $this->db->query("SELECT * FROM roles");
        return $stmt->fetchAll();
    }

    public function getCount() {
        $stmt = $this->db->query("SELECT COUNT(*) FROM users");
        return $stmt->fetchColumn();
    }
}