<?php
require_once __DIR__ . '/../../core/Database.php';

class StudentModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->prepare("SELECT s.*, c.name as class_name, p.father_name 
                                    FROM students s 
                                    JOIN classes c ON s.class_id = c.id 
                                    JOIN parents p ON s.parent_id = p.id 
                                    ORDER BY s.created_at DESC");
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM students WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function getClasses() {
        $stmt = $this->db->query("SELECT * FROM classes");
        return $stmt->fetchAll();
    }

    public function create($data) {
        $sql = "INSERT INTO students (admission_no, first_name, last_name, gender, dob, class_id, parent_id) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute([
            $data['admission_no'],
            $data['first_name'],
            $data['last_name'],
            $data['gender'],
            $data['dob'],
            $data['class_id'],
            $data['parent_id']
        ]);
    }

    public function update($id, $data) {
        $sql = "UPDATE students SET first_name=?, last_name=?, gender=?, dob=?, class_id=?, parent_id=? WHERE id=?";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute([
            $data['first_name'],
            $data['last_name'],
            $data['gender'],
            $data['dob'],
            $data['class_id'],
            $data['parent_id'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM students WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    // Helper to create parent quickly if not exists (Simplified for this step)
    public function createParent($data) {
        $sql = "INSERT INTO parents (father_name, mother_name, phone, email, address) VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$data['father_name'], $data['mother_name'], $data['phone'], $data['email'], $data['address']]);
        return $this->db->lastInsertId();
    }
}