<?php
require_once __DIR__ . '/../../core/Database.php';

class ResultModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function saveMarks($exam_id, $student_id, $subject_id, $marks) {
        // Upsert logic (Update if exists, Insert if new)
        $sql = "INSERT INTO exam_results (exam_id, student_id, subject_id, marks_obtained) 
                VALUES (?, ?, ?, ?) 
                ON DUPLICATE KEY UPDATE marks_obtained = ?";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute([$exam_id, $student_id, $subject_id, $marks, $marks]);
    }

    public function getStudentResults($student_id) {
        $stmt = $this->db->prepare("SELECT er.*, e.name as exam_name, s.name as subject_name, s.code as subject_code
                                    FROM exam_results er
                                    JOIN exams e ON er.exam_id = e.id
                                    JOIN subjects s ON er.subject_id = s.id
                                    WHERE er.student_id = ?
                                    ORDER BY e.year DESC, e.term DESC");
        $stmt->execute([$student_id]);
        return $stmt->fetchAll();
    }

    public function getResultsByExamClass($exam_id, $class_id) {
        $stmt = $this->db->prepare("SELECT s.id as student_id, s.first_name, s.last_name, s.admission_no,
                                    er.subject_id, er.marks_obtained
                                    FROM students s
                                    LEFT JOIN exam_results er ON s.id = er.student_id AND er.exam_id = ?
                                    WHERE s.class_id = ?");
        $stmt->execute([$exam_id, $class_id]);
        return $stmt->fetchAll();
    }

    public function getGrade($marks) {
        $stmt = $this->db->prepare("SELECT * FROM grade_scales WHERE ? BETWEEN min_marks AND max_marks");
        $stmt->execute([$marks]);
        return $stmt->fetch();
    }
}