<?php
require_once __DIR__ . '/../../core/Database.php';

class MessageModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function send($sender_id, $receiver_id, $subject, $message) {
        $stmt = $this->db->prepare("INSERT INTO messages (sender_id, receiver_id, subject, message) VALUES (?, ?, ?, ?)");
        return $stmt->execute([$sender_id, $receiver_id, $subject, $message]);
    }

    public function getInbox($user_id) {
        $stmt = $this->db->prepare("SELECT m.*, s.username as sender_name 
                                    FROM messages m 
                                    JOIN users s ON m.sender_id = s.id 
                                    WHERE m.receiver_id = ? 
                                    ORDER BY m.created_at DESC");
        $stmt->execute([$user_id]);
        return $stmt->fetchAll();
    }

    public function getSent($user_id) {
        $stmt = $this->db->prepare("SELECT m.*, r.username as receiver_name 
                                    FROM messages m 
                                    JOIN users r ON m.receiver_id = r.id 
                                    WHERE m.sender_id = ? 
                                    ORDER BY m.created_at DESC");
        $stmt->execute([$user_id]);
        return $stmt->fetchAll();
    }

    public function markAsRead($id) {
        $stmt = $this->db->prepare("UPDATE messages SET is_read = 1 WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public function getAllUsers() {
        $stmt = $this->db->query("SELECT id, username, full_name FROM users WHERE is_active = 1");
        return $stmt->fetchAll();
    }
}