<?php
require_once __DIR__ . '/../../core/Database.php';

class FeeModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getFeeTypes() {
        return $this->db->query("SELECT * FROM fee_types")->fetchAll();
    }

    public function createStructure($data) {
        $stmt = $this->db->prepare("INSERT INTO fee_structures (class_id, fee_type_id, amount, academic_year) VALUES (?, ?, ?, ?)");
        return $stmt->execute([$data['class_id'], $data['fee_type_id'], $data['amount'], $data['year']]);
    }

    public function getStructureByClass($class_id, $year) {
        $stmt = $this->db->prepare("SELECT fs.*, ft.name as fee_name 
                                    FROM fee_structures fs 
                                    JOIN fee_types ft ON fs.fee_type_id = ft.id 
                                    WHERE fs.class_id = ? AND fs.academic_year = ?");
        $stmt->execute([$class_id, $year]);
        return $stmt->fetchAll();
    }

    public function createInvoice($data) {
        $stmt = $this->db->prepare("INSERT INTO invoices (invoice_no, student_id, class_id, total_amount, balance_amount, due_date) VALUES (?, ?, ?, ?, ?, ?)");
        return $stmt->execute([$data['invoice_no'], $data['student_id'], $data['class_id'], $data['total'], $data['total'], $data['due_date']]);
    }

    public function getInvoicesByStudent($student_id) {
        $stmt = $this->db->prepare("SELECT * FROM invoices WHERE student_id = ? ORDER BY created_at DESC");
        $stmt->execute([$student_id]);
        return $stmt->fetchAll();
    }

    public function getInvoiceById($id) {
        $stmt = $this->db->prepare("SELECT i.*, s.first_name, s.last_name, s.admission_no 
                                    FROM invoices i 
                                    JOIN students s ON i.student_id = s.id 
                                    WHERE i.id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function updateInvoiceBalance($invoice_id, $paid_amount, $balance, $status) {
        $stmt = $this->db->prepare("UPDATE invoices SET paid_amount = paid_amount + ?, balance_amount = ?, status = ? WHERE id = ?");
        return $stmt->execute([$paid_amount, $balance, $status, $invoice_id]);
    }

    public function recordPayment($data) {
        $stmt = $this->db->prepare("INSERT INTO payments (invoice_id, amount, payment_date, payment_method, transaction_ref, remarks, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
        return $stmt->execute([$data['invoice_id'], $data['amount'], $data['date'], $data['method'], $data['ref'], $data['remarks'], $data['user_id']]);
    }

    public function getPaymentsByInvoice($invoice_id) {
        $stmt = $this->db->prepare("SELECT * FROM payments WHERE invoice_id = ? ORDER BY created_at DESC");
        $stmt->execute([$invoice_id]);
        return $stmt->fetchAll();
    }
}