<?php
require_once __DIR__ . '/../../core/Database.php';

class ExamModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->query("SELECT * FROM exams ORDER BY created_at DESC");
        return $stmt->fetchAll();
    }

    public function create($data) {
        $stmt = $this->db->prepare("INSERT INTO exams (name, year, term) VALUES (?, ?, ?)");
        return $stmt->execute([$data['name'], $data['year'], $data['term']]);
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM exams WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }
    
    public function getSubjectsByClass($class_id) {
        $stmt = $this->db->prepare("SELECT s.* FROM subjects s 
                                    JOIN class_subjects cs ON s.id = cs.subject_id 
                                    WHERE cs.class_id = ?");
        $stmt->execute([$class_id]);
        return $stmt->fetchAll();
    }
}