<?php
/**
 * Class Model
 * Handles all class-related database operations
 */
require_once __DIR__ . '/../../core/Database.php';

class ClassModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->query("SELECT * FROM classes ORDER BY name ASC");
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM classes WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($name, $section) {
        $stmt = $this->db->prepare("INSERT INTO classes (name, section) VALUES (?, ?)");
        return $stmt->execute([$name, $section]);
    }

    public function update($id, $name, $section) {
        $stmt = $this->db->prepare("UPDATE classes SET name=?, section=? WHERE id=?");
        return $stmt->execute([$name, $section, $id]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM classes WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public function getStudentCount($class_id) {
        $stmt = $this->db->prepare("SELECT COUNT(*) FROM students WHERE class_id = ?");
        $stmt->execute([$class_id]);
        return $stmt->fetchColumn();
    }

    public function getTeacherCount($class_id) {
        $stmt = $this->db->prepare("SELECT COUNT(DISTINCT u.id) FROM users u 
                                    JOIN class_subjects cs ON u.id = cs.teacher_id 
                                    WHERE cs.class_id = ?");
        $stmt->execute([$class_id]);
        return $stmt->fetchColumn();
    }
}